

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

//////////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	
	float2 uv1			: TEXCOORD0;
};
	
	
struct VS_OUTPUT 
{
	float4 position		: POSITION;

	float2 uv1			: TEXCOORD0;
};

//////////////////////////////////////////////////////////////

VS_OUTPUT vs_terrainBlendMap( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = input.position;
	output.uv1 = input.uv1;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Clamp;
	AddressV=Clamp;
};

////////////////////////////////////////////////////////////

float4 ps_terrainBlendMap( VS_OUTPUT input ) : COLOR0
{
	return float4(1,0,0,0);
}

////////////////////////////////////////////////////////////

technique terrainBlendMap_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_terrainBlendMap();	
		PixelShader = compile ps_2_0 ps_terrainBlendMap();	
	}
}


technique terrainBlendMap_11_00
{
	pass P0
	{
	}
}

////////////////////////////////////////////////////////////
